﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Place;
using Soneta.Core;

namespace ASP {

    public partial class Wypłata_Pasek : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_PracInfoEtat = "PESEL: <strong>{0}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Wymiar etatu: <strong>{1}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tytuł ubezpieczenia: <strong>{2}</strong>";
        public string Str_PracInfoUmowa = "PESEL: <strong>{0}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tytuł ubezpieczenia: <strong>{1}</strong>";
        public string Str_PracInfo = "PESEL: <strong>{0}</strong>";
        public string Str_Regon = "REGON:";
        public string Str_PlecM = "świadomy";
        public string Str_PlecK = "świadoma";

        static bool procentInfo = false;
        static bool skladnikiInfo = false;
        static bool procentPit = false;
        //Włącza drukowanie podsumowania funduszy pożyczkowych. UWAGA! Informacja wg stanu
        //aktualnego a nie na dzień wypłaty.
        static bool funduszePożyczkowe = false;
        static bool daneFirmy = true;

        protected void gridHeader_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
            Wyplata wypłata = dc[typeof(Wyplata)] as Wyplata;

            WyplataEtat we = wypłata as WyplataEtat;
            Wyplata.ZUSInfoWorker zusinfo = new Wyplata.ZUSInfoWorker();
            zusinfo.Wypłata = wypłata;
            if (we != null)
                //colPracInfo.EditValue = string.Format("PESEL: <strong>{0}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Wymiar etatu: <strong>{1}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tytuł ubezpieczenia: <strong>{2}</strong>",
			    colPracInfo.EditValue = string.Format(Str_PracInfoEtat,
                    wypłata.PracHistoria.PESEL,
                    wypłata.PracHistoria.Etat.Zaszeregowanie.Wymiar,
                    zusinfo.TytułUbezpieczenia/*wypłata.PracHistoria.Etat.Ubezpieczenia.Tyub*/);
            else {
                Umowa umowa = wypłata is WyplataUmowa ? ((WyplataUmowa)wypłata).Umowa : null;
                if (umowa != null)
                    //colPracInfo.EditValue = string.Format("PESEL: <strong>{0}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tytuł ubezpieczenia: <strong>{1}</strong>",
				    colPracInfo.EditValue = string.Format(Str_PracInfoUmowa,
                        wypłata.PracHistoria.PESEL,
                        zusinfo.TytułUbezpieczenia/*umowa.Ubezpieczenia.Tyub*/);
                else
                    //colPracInfo.EditValue = string.Format("PESEL: <strong>{0}</strong>",
				    colPracInfo.EditValue = string.Format(Str_PracInfo,
                        wypłata.PracHistoria.PESEL);
            }
    
            Currency ror = wypłata.Inne;
            colGotowka.EditValue = wypłata.WartoscCy-ror;
            colROR.EditValue = ror;
		    colOkres.EditValue = wypłata.ListaPlac.Okres.ToString();

            if (wypłata.Data.Year < 2022)
            {
                if(Str_CultureInfo == "en-GB")
                    GridColumn9.Format = "Health Insur. Contr. To Be Deducted:";
                else
                    GridColumn9.Format = "Zdrow.do odlicz:";

                GridColumn10.DataMember = "Workers.PITInfo.ZdrowotneDoOdliczenia";
            }
            else
            {
                if(Str_CultureInfo == "en-GB")
                    GridColumn9.Format = "Middle class relief:";
                else
                    GridColumn9.Format = "Ulga klasa średnia:"; 

                GridColumn10.DataMember = "Workers.PITInfo.UlgaKlasaSrednia";
            }
        }

        private string Korygowany(WypElement element, System.Globalization.CultureInfo ci) {
            /*
            string korektaTxt = " (korekta)".Translate(null, ci);
            string depozytTxt = " (depozyt)".Translate(null, ci);
            string nazwa = element.Nazwa.Translate(null, ci);
            if (element.Definicja.Korygowany && nazwa.EndsWith(korektaTxt))
                nazwa = nazwa.Replace(korektaTxt, "");
            else if (element is WypElementZajęcieKomornicze && nazwa.EndsWith(depozytTxt))
                nazwa = nazwa.Replace(depozytTxt, "");
            return nazwa;
            */
            return element.TranslatedName(ci);
        }

        static readonly string prefix = "&nbsp;&nbsp;&nbsp;&nbsp;";
	    protected void gridElements_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
            WypElement element = (WypElement)args.Row;

            System.Globalization.CultureInfo ci = new System.Globalization.CultureInfo(Str_CultureInfo);

            if (!skladnikiInfo)	{
			    if (element.Wartosc==0)
				    args.VisibleRow = false;
			    else {
				    colNazwa.AddLine(Korygowany(element, ci));
				    WypSkladnikGłówny skg = element.SkładnikGłówny;
				    colProcent.AddLine(skg==null ? Percent.Zero : skg.Procent);
				    colCzas.AddLine(element.Czas);
				    colDni.AddLine(element.Dni);
				    AddWartosc(element.Wartosc);
			    }
            }
		    else 
			    foreach (WypSkladnik sk in element.Skladniki) {
				    WypSkladnikGłówny skg = sk as WypSkladnikGłówny;
				    if (skg!=null) {
					    colNazwa.AddLine(Korygowany(element, ci));
					    colProcent.AddLine(skg.Procent);
					    colCzas.AddLine(skg.Czas);
					    colDni.AddLine(skg.Dni);
					    AddWartosc(skg.Wartosc);
				    }
				    else {
					    WypSkladnikPomniejszenie skp = sk as WypSkladnikPomniejszenie;
					    if (skp!=null) {
						    colNazwa.AddLine(prefix + skp.Nieobecnosc.Definicja.GetLocalizedNazwa(ci) + " (" + skp.Okres.ToString() + ")");
						    colProcent.AddLine(skp.Procent);
						    colCzas.AddLine(skp.Czas);
						    colDni.AddLine(skp.Dni);
						    colDodatek.AddLine(skp.Wartosc);
						    colPotracenie.AddLine(0m);
					    }
					    else {
						    colNazwa.AddLine(prefix + CaptionAttribute.EnumToString(sk.Rodzaj, ci));
						    colProcent.AddLine(sk.Procent);
						    colCzas.AddLine(sk.Czas);
						    colDni.AddLine(sk.Dni);
						    colDodatek.AddLine(sk.Wartosc);
						    colPotracenie.AddLine(0m);
					    }
				    }
			    }            
        }
    
        void AddWartosc(decimal v) {
		    if (v>=0) {
			    colDodatek.AddLine(v);
			    colPotracenie.AddLine(0m);
		    }
		    else {
			    colDodatek.AddLine(0m);
			    colPotracenie.AddLine(-v);
		    }
        }

        protected void dc_ContextLoad(Object sender, EventArgs args) {
            if (!procentPit) {
			    colPitInfo.Format = "";
			    colPitProcent.DataMember = "";			
		    }
		
            Wyplata wypłata = (Wyplata)dc[typeof(Wyplata)];
            gridHeader.DataSource = new object[] { new ContextObject(wypłata, dc.Context) };
            gridElements.DataSource = wypłata.ElementyWgKolejności;
        
		    colProcent.Visible = procentInfo;
		
		    ArrayList fundusze = new ArrayList();
		    foreach (FundPozyczkowy f in wypłata.Pracownik.FunduszePozyczkowe)
			    fundusze.Add(f);
	
		    if (fundusze.Count==0 || !funduszePożyczkowe || !(wypłata is WyplataEtat))
			    gridFundusze.Visible = false;
		    else {
			    ListWithView lvw = new ListWithView(fundusze, wypłata.Pracownik.Module.FundPozyczkowe.PrimaryKey);
			    gridFundusze.DataSource = lvw;
		    }
		
		    if (daneFirmy) {
			    GridFirma.DataSource = new object [] { dc.Session };
			    CoreModule core = CoreModule.GetInstance(dc);
			    string ss = core.Config.Firma.Pieczątka.NUSP;
			    if (ss=="") {
                    colNuspTitle.Format = Str_Regon;
				    ss = core.Config.Firma.Pieczątka.REGON;
			    }
			    colNUSP.Format = ss;
		    }
            else
			    GridFirma.Visible = daneFirmy;

            dlPlec.EditValue = wypłata.PracHistoria.Plec == PłećOsoby.Mężczyzna ? Str_PlecM : Str_PlecK;
        }
    }
}
